# Explore Data #
rm(list=ls(all=TRUE))
library("gplots") 
library("ggplot2")
library("Rtsne")
require("lattice")
library("GGally")
library('ggrepel')
library("DESeq2")

# Load sample information # 
args = commandArgs(trailingOnly=TRUE)

colData<- read.table(args[1], header=TRUE, sep="\t", row.names=NULL)
names<-colData$X
count.matrix <- read.table(args[2], header=TRUE, sep="\t", row.names=1,quote = "",check.names=FALSE)
dds = DESeqDataSetFromMatrix(countData =round(count.matrix), colData = colData, design = ~ Genotype)
Genotype<-colData$Genotype

dds <- estimateSizeFactors(dds)
dat <- counts(dds, normalized = TRUE)
idx <- rowMeans(dat) > 50
dat <- dat[idx,]
dds <- dds[idx,]
dds <- DESeq(dds, betaPrior = FALSE)
res.geno <- results(dds, contrast = c("Genotype", "TR", "CT"))
res.geno$FC <- 2^res.geno$log2FoldChange
pr<- data.frame(ID =seq.int(nrow(as.data.frame(res.geno))),Gene = row.names(as.data.frame(res.geno)), as.data.frame(res.geno))
write.table(pr, file=args[3], sep="\t",row.names=F,quote = FALSE)  

# Counts Log transform #
tt = counts(dds,normalized = FALSE)
tt<-log(tt+1)
tt<-t(tt)

# PCA plot #
pca<-prcomp(tt)
PCi<-data.frame(pca$x,S=names)
# proportion of variance
variance = pca$sdev^2 / sum(pca$sdev^2)
variance = round(variance, 3) * 100
allpc=paste(as.character(variance),collapse=", ")
tiff("PCA.tif",width=10, height=8, units='in',res=200)
ggplot(PCi,aes(x=PC1,y=PC2))+
  geom_point(size=2,aes(color=Genotype),alpha=0.5)+
  #geom_text(aes(label=names),hjust=0.5, vjust=-1)+
  theme_bw()+
  scale_x_continuous(name = paste(c("PC1 :",variance[1],"%" ), collapse = ""))+
  scale_y_continuous(name = paste(c("PC2 :",variance[2],"%" ), collapse = ""))+
  geom_text_repel(label=names)+
  ggtitle(paste(c("PCs:",allpc),collapse=" "))+
  theme(plot.title = element_text(hjust = 0.5,vjust = 0))
dev.off()

