rm(list=ls(all=TRUE))
library("ggplot2")
library("cowplot")

# Read Scatter Data #
frame <- read.table("RosMap.CrypticLoad.txt", header=TRUE, sep="\t",row.name=1)
frame1<- frame[order(frame$SqrtNft),]
frame2<- frame[rev(order(frame$SqrtNft)),]

xl<-list()
xl[3]="No. of Cryptic Junctions "
xl[9]="Avg. Cryptic Junction Read count "
xl[11]="Avg. Cryptic Junction strength "
xl[14]="Nor No. of Cryptic Junctions "
xl[20]="Nor Avg. Cryptic Junction Read count "
xl[22]="Nor Avg. Cryptic Junction strength "

for (i in c(3,9,11,14,20,22))
{
  myplots<-list()
  j=1
  for (n in seq(25,300,25))
  {
    c<-frame1[1:n,]
    t<-frame2[1:n,]
    cols=colnames(frame)
    ecdf1 <- ecdf(t[[cols[i]]])
    ecdf2 <- ecdf(c[[cols[i]]])
    #p=ks.test(t[[cols[i]]],c[[cols[i]]],alternative="less")
    p=ks.test(t[[cols[i]]],c[[cols[i]]])
    mi=min(min(t[[cols[i]]]),min(c[[cols[i]]]))
    ma=max(max(t[[cols[i]]]),max(c[[cols[i]]]))
    d <- data.frame(x = c(mi,ma))
    ll <- Map(f  = stat_function, colour = c('red', 'blue'),
              fun = list(ecdf1, ecdf2), geom = 'step',size=1)
    p<-ggplot(data = d, aes(x = x)) + ll+
      xlab(paste0(xl[i],n*2," Samples"))+
      ylab(paste0("Cummilative dennsity function"))+
      theme_classic()+
      ggtitle(paste0(p$p.value))+
      theme(text= element_text(size=14),axis.line = element_line(colour = 'black', size = 1),plot.title = element_text(hjust = 0.5),axis.text.x = element_text(angle=0, vjust=0.5))
    myplots[[j]]=p
    j=j+1
  }
  tiff(paste0("NFTSpliceLoad.",cols[i],".tif"),width=16, height=14, units='in',res=600)
  print(plot_grid(myplots[[1]],myplots[[2]],myplots[[3]],myplots[[4]],myplots[[5]],myplots[[6]],myplots[[7]],myplots[[8]],
                  myplots[[9]],myplots[[10]],myplots[[11]],myplots[[12]],
                  labels = c(),ncol = 4, nrow = 3))
  dev.off()
}


# BRAC Score low Vs High #
# Read Scatter Data #
rm(list=ls(all=TRUE))
frame <- read.table("RosMap.CrypticLoad.txt", header=TRUE, sep="\t",row.name=1)
frame1<- frame[frame$BRAC_C==1,]
frame2<- frame[frame$BRAC_C==0,]
xl<-list()
xl[3]="No. of Cryptic Junctions "
xl[9]="Avg. Cryptic Junction Read count "
xl[11]="Avg. Cryptic Junction strength "
xl[14]="Nor No. of Cryptic Junctions "
xl[20]="Nor Avg. Cryptic Junction Read count "
xl[22]="Nor Avg. Cryptic Junction strength "

myplots<-list()
j=1
for (i in c(3,9,11,14,20,22))
{
  t<-frame1
  c<-frame2
  cols=colnames(frame)
  ecdf1 <- ecdf(t[[cols[i]]])
  ecdf2 <- ecdf(c[[cols[i]]])
  p=ks.test(t[[cols[i]]],c[[cols[i]]])
  #p=ks.test(t[[cols[i]]],c[[cols[i]]])
  mi=min(min(t[[cols[i]]]),min(c[[cols[i]]]))
  ma=max(max(t[[cols[i]]]),max(c[[cols[i]]]))
  d <- data.frame(x = c(mi,ma))
  ll <- Map(f  = stat_function, colour = c('red', 'blue'),
            fun = list(ecdf1, ecdf2), geom = 'step',size=1)
  p<-ggplot(data = d, aes(x = x)) + ll+
    xlab(paste0(xl[i]," AD:",nrow(frame1)," CR:",nrow(frame2)))+
    ylab(paste0("Cummilative dennsity function"))+
    theme_classic()+
    ggtitle(paste0("Pval: ",p$p.value))+
    theme(text= element_text(size=14),axis.line = element_line(colour = 'black', size = 1),plot.title = element_text(hjust = 0.5),axis.text.x = element_text(angle=0, vjust=0.5))
  myplots[[j]]=p
  j=j+1
}

tiff(paste0("BRACSpliceLoad.tif"),width=16, height=10, units='in',res=600)
print(plot_grid(myplots[[1]],myplots[[2]],myplots[[3]],
                myplots[[4]],myplots[[5]],myplots[[6]],
                labels = c(),ncol = 3, nrow = 2))
dev.off()

# Reagan_C Score low Vs High #
# Read Scatter Data #
rm(list=ls(all=TRUE))
frame <- read.table("RosMap.CrypticLoad.txt", header=TRUE, sep="\t",row.name=1)
frame1<- frame[frame$Reagan_C==1,]
frame2<- frame[frame$Reagan_C==0,]
xl<-list()
xl[3]="No. of Cryptic Junctions "
xl[9]="Avg. Cryptic Junction Read count "
xl[11]="Avg. Cryptic Junction strength "
xl[14]="Nor No. of Cryptic Junctions "
xl[20]="Nor Avg. Cryptic Junction Read count "
xl[22]="Nor Avg. Cryptic Junction strength "

myplots<-list()
j=1
for (i in c(3,9,11,14,20,22))
{
  t<-frame1
  c<-frame2
  cols=colnames(frame)
  ecdf1 <- ecdf(t[[cols[i]]])
  ecdf2 <- ecdf(c[[cols[i]]])
  p=ks.test(t[[cols[i]]],c[[cols[i]]],alternative="less")
  #p=ks.test(t[[cols[i]]],c[[cols[i]]])
  mi=min(min(t[[cols[i]]]),min(c[[cols[i]]]))
  ma=max(max(t[[cols[i]]]),max(c[[cols[i]]]))
  d <- data.frame(x = c(mi,ma))
  ll <- Map(f  = stat_function, colour = c('red', 'blue'),
            fun = list(ecdf1, ecdf2), geom = 'step',size=1)
  p<-ggplot(data = d, aes(x = x)) + ll+
    xlab(paste0(xl[i]," AD:",nrow(frame1)," CR:",nrow(frame2)))+
    ylab(paste0("Cummilative dennsity function"))+
    theme_classic()+
    ggtitle(paste0("Pval: ",p$p.value))+
    theme(text= element_text(size=14),axis.line = element_line(colour = 'black', size = 1),plot.title = element_text(hjust = 0.5),axis.text.x = element_text(angle=0, vjust=0.5))
  myplots[[j]]=p
  j=j+1
}

tiff(paste0("ReaganSpliceLoad.",cols[i],".tif"),width=16, height=10, units='in',res=600)
print(plot_grid(myplots[[1]],myplots[[2]],myplots[[3]],
                myplots[[4]],myplots[[5]],myplots[[6]],
                labels = c(),ncol = 3, nrow = 2))
dev.off()





