rm(list=ls(all=TRUE))
library("ggplot2")
library("cowplot")
xl<-list();xl[3]="CJ1";xl[9]="JC1";xl[11]="JS1"
xl[14]="CJ2";xl[20]="JC2";xl[22]="JS2"
frame <- read.table("RosMap.CrypticLoad.txt", header=TRUE, sep="\t",row.name=1)
#frame<- frame[which(frame$Batch !=7 &  frame$Batch !=8),]
#frame$Batch<-as.factor(frame$Batch)
#frame$BRAC_C<-as.factor(frame$BRAC_C)
#frame$Reagan_C<-as.factor(frame$Reagan_C)

# sqrt NFT low vs high #
frame1<- frame[order(frame$SqrtNft),]
frame2<- frame[rev(order(frame$SqrtNft)),]

write(paste("Target_N","NFT","Batch","PMI","Age",sep="\t"), file = paste0("sqrtNFT_Models_P_fit2.txt"),append = FALSE, sep = "\t")
write(paste("Target_N","NFT","Batch","Age",sep="\t"), file = paste0("sqrtNFT_Models_P_fit3.txt"),append = FALSE, sep = "\t")

write(paste("Target_N","NFT","Batch","PMI","Age",sep="\t"), file = paste0("sqrtNFT_Models_T_fit2.txt"),append = FALSE, sep = "\t")
write(paste("Target_N","NFT","Batch","Age",sep="\t"), file = paste0("sqrtNFT_Models_T_fit3.txt"),append = FALSE, sep = "\t")

for (n in seq(50,300,50))
{
  #n<-100
  c<-frame1[1:n,]
  c$SqrtNft<-0
  t<-frame2[1:n,]
  t$SqrtNft<-1
  d<-rbind(c,t)
  
  for (i in c(3,9,11,14,20,22))
  {
    write(paste0("********Exploring ",xl[i]," **************"), file = paste0("sqrtNFT_Models.",n,".txt"),append = TRUE, sep = " ")
    
    #i<-22
    fit1 <-lm( d[[i]] ~ SqrtNft+ Batch + pmi + Age, d)
    p2=as.vector(summary(fit1)$coefficients[, 4])
    capture.output(summary(fit1), file = paste0("sqrtNFT_Models.",n,".txt"),append = TRUE)
    fit2 <-lm( d[[i]] ~ SqrtNft+ Batch + Age, d)
    p3=as.vector(summary(fit2)$coefficients[, 4])
    capture.output(summary(fit2), file = paste0("sqrtNFT_Models.",n,".txt"),append = TRUE)
    
    t2=as.vector(summary(fit1)$coefficients[, 3])
    t3=as.vector(summary(fit2)$coefficients[, 3])
   
    write(paste(paste(xl[[i]],n,sep="_"),paste(p2[-1],collapse="\t"),sep="\t"), file = paste0("sqrtNFT_Models_P_fit2.txt"),append = TRUE, sep = "\t")
    write(paste(paste(xl[[i]],n,sep="_"),paste(p3[-1],collapse="\t"),sep="\t"), file = paste0("sqrtNFT_Models_P_fit3.txt"),append = TRUE, sep = "\t")

    write(paste(paste(xl[[i]],n,sep="_"),paste(t2[-1],collapse="\t"),sep="\t"), file = paste0("sqrtNFT_Models_T_fit2.txt"),append = TRUE, sep = "\t")
    write(paste(paste(xl[[i]],n,sep="_"),paste(t3[-1],collapse="\t"),sep="\t"), file = paste0("sqrtNFT_Models_T_fit3.txt"),append = TRUE, sep = "\t")
    
  }
}

# BRAC Score low Vs High #
t<- frame[frame$BRAC_C==1,]
c<- frame[frame$BRAC_C==0,]
d<-rbind(c,t)

write(paste("Target","BRAC","Batch","PMI","Age",sep="\t"), file = paste0("BRAC_Models_P_fit2.txt"),append = FALSE, sep = "\t")
write(paste("Target","BRAC","Batch","Age",sep="\t"), file = paste0("BRAC_Models_P_fit3.txt"),append = FALSE, sep = "\t")

write(paste("Target","BRAC","Batch","PMI","Age",sep="\t"), file = paste0("BRAC_Models_T_fit2.txt"),append = FALSE, sep = "\t")
write(paste("Target","BRAC","Batch","Age",sep="\t"), file = paste0("BRAC_Models_T_fit3.txt"),append = FALSE, sep = "\t")

for (i in c(3,9,11,14,20,22))
{
  write(paste0("********Exploring ",xl[i]," **************"), file = "BRAC_Models.txt",append = TRUE, sep = " ")
  
  fit1 <-lm( d[[i]] ~ BRAC_C+ Batch + pmi + Age, d)
  tiff("BRAKK.tif",width=14, height=10, units='in',res=600)
  autoplot(fit1, label.size = 4)+theme_bw()
  dev.off()
  p2=as.vector(summary(fit1)$coefficients[, 4])
  capture.output(summary(fit1), file = "BRAC_Models.txt",append = TRUE)
  fit2 <-lm( d[[i]] ~ BRAC_C+ Batch + Age, d)
  p3=as.vector(summary(fit2)$coefficients[, 4])
  capture.output(summary(fit2), file = "BRAC_Models.txt",append = TRUE)
  
  t2=as.vector(summary(fit1)$coefficients[, 3])
  t3=as.vector(summary(fit2)$coefficients[, 3])
  
  write(paste(xl[[i]],paste(p2[-1],collapse="\t"),sep="\t"), file = paste0("BRAC_Models_P_fit2.txt"),append = TRUE, sep = "\t")
  write(paste(xl[[i]],paste(p3[-1],collapse="\t"),sep="\t"), file = paste0("BRAC_Models_P_fit3.txt"),append = TRUE, sep = "\t")

  write(paste(xl[[i]],paste(t2[-1],collapse="\t"),sep="\t"), file = paste0("BRAC_Models_T_fit2.txt"),append = TRUE, sep = "\t")
  write(paste(xl[[i]],paste(t3[-1],collapse="\t"),sep="\t"), file = paste0("BRAC_Models_T_fit3.txt"),append = TRUE, sep = "\t")
  
}



# Reagan_C Score low Vs High #
t<- frame[frame$Reagan_C==1,]
c<- frame[frame$Reagan_C==0,]
d<-rbind(c,t)

write(paste("Target","Reagan","Batch","PMI","Age",sep="\t"), file = paste0("Reagan_Models_P_fit2.txt"),append = FALSE, sep = "\t")
write(paste("Target","Reagan","Batch","Age",sep="\t"), file = paste0("Reagan_Models_P_fit3.txt"),append = FALSE, sep = "\t")

write(paste("Target","Reagan","Batch","PMI","Age",sep="\t"), file = paste0("Reagan_Models_T_fit2.txt"),append = FALSE, sep = "\t")
write(paste("Target","Reagan","Batch","Age",sep="\t"), file = paste0("Reagan_Models_T_fit3.txt"),append = FALSE, sep = "\t")

for (i in c(3,9,11,14,20,22))
{
  write(paste0("********Exploring ",xl[i]," **************"), file = "Reagan_Models.txt",append = TRUE, sep = " ")
  
  fit1 <-lm( d[[i]] ~ Reagan_C+ Batch + pmi + Age, d)
  tiff("Reagan.tif",width=14, height=10, units='in',res=600)
  autoplot(fit1, label.size = 4)+theme_bw()
  dev.off()
  p2=as.vector(summary(fit1)$coefficients[, 4])
  capture.output(summary(fit1), file = "Reagan_Models.txt",append = TRUE)
  fit2 <-lm( d[[i]] ~ Reagan_C+ Batch + Age, d)
  p3=as.vector(summary(fit2)$coefficients[, 4])
  capture.output(summary(fit2), file = "Reagan_Models.txt",append = TRUE)
  
  t2=as.vector(summary(fit1)$coefficients[, 3])
  t3=as.vector(summary(fit2)$coefficients[, 3])
  
  write(paste(xl[[i]],paste(p2[-1],collapse="\t"),sep="\t"), file = paste0("Reagan_Models_P_fit2.txt"),append = TRUE, sep = "\t")
  write(paste(xl[[i]],paste(p3[-1],collapse="\t"),sep="\t"), file = paste0("Reagan_Models_P_fit3.txt"),append = TRUE, sep = "\t")

  write(paste(xl[[i]],paste(t2[-1],collapse="\t"),sep="\t"), file = paste0("Reagan_Models_T_fit2.txt"),append = TRUE, sep = "\t")
  write(paste(xl[[i]],paste(t3[-1],collapse="\t"),sep="\t"), file = paste0("Reagan_Models_T_fit3.txt"),append = TRUE, sep = "\t")
  
}

