import os, sys, glob
import pandas as pd
from collections import defaultdict
from StringIO import StringIO


def make_matrix(lst_file, ncr, ntr):
    """input: list of files <Junction Counts> <Exoncounts> <Junction annotation >
    output: Matrix file for statistical testing"""
    file_path_csv1 = os.path.join(os.path.dirname(lst_file[0]), 'CrypMatrixUN.csv')
    file_path_csv2 = os.path.join(os.path.dirname(lst_file[0]), 'CrypMatrixKN.csv')
    jcount=lst_file[0]
    ecount=lst_file[1:(len(lst_file)-1)]
    janno=lst_file[-1]
    # Red junction count #
    df=pd.DataFrame.from_csv(jcount,sep=",",index_col=None)

    for ec in ecount:
        # read each exon count file and append to junction counts data frame #
        data = pd.read_csv(ec, skiprows=range(0,1), sep="\t",index_col=None)
        ec = "{}_ex".format(os.path.basename(ec).rsplit("_",1)[0])
        df[ec] = data.iloc[:,-1].tolist()

    # Get Junction and Exon average counts #
    df['WT_Javg'] = df[df.columns[5:5+ncr]].mean(axis=1)
    st = 5+ncr
    df['MT_Javg'] = df[df.columns[st:st+ntr]].mean(axis=1)
    st += ntr
    df['WT_Eavg'] = df[df.columns[st:st+ncr]].mean(axis=1)
    st += ncr
    df['MT_Eavg'] = df[df.columns[st:st+ntr]].mean(axis=1)
    # Get junction strength columns and diff #
    df['WT_JS'] = df['WT_Javg']/df['WT_Eavg']
    df['MT_JS'] = df['MT_Javg']/df['MT_Eavg']
    df['Js_diff']=df['WT_JS']-df['MT_JS']

    # read junction annotations #
    df2 = pd.DataFrame.from_csv(janno,sep="\t",index_col=None)
    df2 = df2.rename(columns={'name': 'ID'})
    df2.drop(df2.columns[[0,1,2,4,5]], inplace=True, axis=1)
    df2=df2.fillna("NA")
    #pd.merge(df, df2, on='ID').to_csv(file_path_csv, index=False)
    df3=pd.merge(df, df2, on='ID')
    df3.loc[df3['known_junction'] == 0].to_csv(file_path_csv1, index=False)
    df3.loc[df3['known_junction'] == 1].to_csv(file_path_csv2, index=False)

def main():
    make_matrix(sys.argv[3:], int(sys.argv[1]), int(sys.argv[2]))


if __name__ == "__main__":
    main()
