# Test Command: python getExonCounts.py Junction_Annotations.txt 8

import os,sys,glob
import Utils
import tempfile

def get_exon_counts(ja_file, bam_files, ncores):
    """
    input: Reference junctions annotation file and list of BAM files
    output: Reference junction 5'exon count files
    """

    tmp_path = os.path.join(tempfile.gettempdir(), "tmp.saf")

    # Get 5' Exon Coordinates as SAF file #
    with open(ja_file, "r") as inp, open(tmp_path, "w") as oup:
        inp.readline()

        for line in inp:
            data=line.split("\t")
            pos = str(int(data[1])-3 if data[5] == "+" else int(data[2])+3)
            record = [data[3], data[0], pos, pos, data[5]]
            oup.write("\t".join(record)+"\n")


    # FeatureCounts #
    for file in bam_files:
        ec_file_path = file.replace(".sorted.bam","_ExonCounts.txt")
        cmd="featureCounts -a {} -F SAF -f -O --readExtension5 100 --readExtension3 100 -M -s 0 -p -B -C -T {}"\
            " -o {} {}".format(tmp_path,
                               ncores,
                               ec_file_path,
                               file)
        #print(cmd)
        os.system(cmd)
        os.unlink(file.replace(".sorted.bam","_ExonCounts.txt.summary"))

    os.unlink(tmp_path)


def main():
    get_exon_counts(sys.argv[2], sys.argv[3:], int(sys.argv[1]))


if __name__ == "__main__":
    main()
