import os,sys,glob
import Utils


def get_bigwig(sample):
    """
    input: sorted and indexed bam file
    output: Bigwig file
    """
    out = sample.replace(".bam",".bw")
    ignore='chr1 chr2 chr3 chr4 chr5 chr6 chr7 chr8 chr9 chr10 chr11 chr12 chr13 chr14 chr15 chr16 chr17 chr18 chr19 chrX chrY'
    cmd = 'bamCoverage -b '+sample+' --scaleFactor 1 -bs 1 -p 10 -ignore '+ignore+' --skipNAs --samFlagInclude 64 -o '+out
    os.system(cmd)


def main():
    #bam_file = "Data/M1.sorted.bam"
    #bed_file = "Data/M1.sorted.bed"
    bam_file = sys.argv[1]
    #bed_file = sys.argv[2]
    #if os.path.exists(bed_file):
    #    os.unlink(bed_file)

    get_bigwig(bam_file)
    #assert os.path.exists(bed_file)


if __name__ == "__main__":
    main()
