# Test Command: python annotateJunctions.py Data/Junction_Counts.csv /nfs/nfs_zhandong/Indexes/Mus_musculus/UCSC/mm1 0_v2/Sequence/WholeGenomeFasta/genome.fa /nfs/nfs_zhandong/Indexes/Mus_musculus/UCSC/mm10_v2/Annotation/Archives/archive-2015-07-17-14-33-26/Genes/g enes.gtf


import os,sys,glob,tempfile
import Utils

def annotateJunctions(jc_file,ref_fasta,ref_annotation):
    """
    input: Reference junctions counts file, ref fasta, ref annotations GTF
    output: Annotated reference junctions
    """
    out = "Junction_Annotations.txt"

    ja_path = os.path.join(os.path.dirname(jc_file), "Junction_Annotations.txt")
    tmp_path = os.path.join(tempfile.gettempdir(), "tmp.bed")

    # Make a temp bed file by  removing all the count data as input to regtools #
    with open(jc_file, "r") as inp, open(tmp_path, "w") as oup:
        inp.readline()
        for i, line in enumerate(inp):
            data=line.split(",")[:5]
            diff = abs(int(data[2])-int(data[3]))

            jline="\t".join([data[1], data[2], data[3], data[0], "0",
                             data[4], data[2], data[3], "255,0,0", "2", "0,0", "0,%d"%diff])
            oup.write(jline+"\n")

    cmd = 'regtools junctions annotate -E -o {} {} {} {}'
    cmd = cmd.format(ja_path, tmp_path, ref_fasta, ref_annotation)
    os.system(cmd)
    os.unlink(tmp_path)


def main():
    annotateJunctions(sys.argv[1], sys.argv[2], sys.argv[3])


if __name__ == "__main__":
    main()
