import os,sys,glob


def adjust_bed(sample, covFilter=10):
    """
    input: junction bed file and min coverage filter (default 10)
    output: overhang adjusted and filtered junction bed ".Ad" files
    """
    fileread = open(sample, 'r')
    filewrite = open(sample + '.Ad', 'w')
    #filewrite2 = open(sample + 'NC.Ad', 'w')
    lines = fileread.readlines()
    for line in lines:
        line.strip()
        data1 = line.split('\t')
        try:
            if "TopHat" in line or "#" in data1[0]:
                pass
            else:
                # if data1[5] !="?": # For HISAT2
                if (int(data1[4]) >= covFilter) and ("chr" in data1[0]):
                    data2 = data1[10].split(',')
                    data1[1] = int(data1[1]) + int(data2[0])
                    data1[2] = int(data1[2]) - int(data2[1])
                    s = '\t'.join(str(v) for v in data1)
                    filewrite.write(s)
                    #if data1[5] !="?":
                    #	filewrite.write(s)
                    #else:
                    #	filewrite.write(s.replace('?','+'))
        except:
            pass
    fileread.close()
    filewrite.close()


def main():
    sample, file_ad, cov_filter = sys.argv[1:4]
    cov_filter = int(cov_filter)
    adjust_bed(sample, cov_filter)
if __name__ == "__main__":
    main()
