import os, sys, glob
import pandas as pd
from collections import defaultdict

def get_junction_counts(lst_file):
    """input: list of junction bed files and error separated by space
    output: All_Junctions bed file"""
    file_path_csv = os.path.join(os.path.dirname(lst_file[0]), 'Junction_Counts.csv')

    count_dict = defaultdict( dict )
    for bed_file in sorted(lst_file):
        sample_id = os.path.basename(bed_file).rsplit('.',1)[0]+"_jc"
        print "hello\t"+sample_id
        with open(bed_file, "r") as inp:
            for line in inp:
                line = line.strip().split("\t")
                chr_pos, chr_start, chr_end, junc_name, coverage, strand = line[:6]
                chr_start = int(chr_start)
                chr_end = int(chr_end)
                coverage = int(coverage)
                key = (chr_pos, chr_start, chr_end, strand)
                count_dict[key][sample_id] = coverage

    count_list = []
    i = 0
    for key, value in sorted(count_dict.items()):
        i += 1
        value["chr"] = key[0]
        value["chr_st"] = key[1]
        value["chr_ed"] = key[2]
        value["strand"] = key[-1]
        value["ID"] = 'Jun_{}'.format(i)
        count_list.append(value)


    df = pd.DataFrame(count_list)
    first_cols = ["ID", "chr", "chr_st", "chr_ed", "strand"]
    cols = first_cols + sorted([ c for c in df.columns.tolist() if not c in first_cols ])
    df = df[cols]
    df=df.fillna(0)
    df.to_csv(file_path_csv, index=False)


def main():
    file_path_csv = sys.argv[1]
    lst = sys.argv[2:]
    get_junction_counts(lst)


if __name__ == "__main__":
    main()
