# Beta Binomial Test # 
library("ibb")
library("MASS")
#library(tidyverse)
args<-commandArgs(TRUE)
group <- c(rep("CTR", as.numeric(args[1])), rep("cKO", as.numeric(args[2])))
nc<-as.numeric(args[6])
ns<-as.numeric(args[1])+as.numeric(args[2])
#data<-read_csv(args[3])
data<-read.csv(args[3])
test<- args[5]
jc<-data[,1:5]
x<-data[,6:(ns+5)]+1
y<-data[,(ns+6):(ns+6+ns-1)]+1

y[x>y] <- x[x>y]

#Class<-data[,ncol(data)]
tail<-data[,(ns+6+ns):ncol(data)]
if(test=="Paired") {
	out<-ibb.test(x, y, group,n.threads = nc)
} else{
	out<-bb.test(x, y, group,n.threads = nc)
}
p<-as.numeric(out$p.value)
for(j in 1:length(p))
{
	if(is.nan(p[j]))
	{
		p[j]=min(p)
	}
}
# Multiple testing correction using BH #
bhp<-p.adjust(p, "BH",length(p))
# Writing to file #
data<-cbind(jc,x,y,p,bhp,tail)
write.csv(data, file = args[4], quote=F)
